/*
   The program "calls" Adder.class as an external process.
   This is a baby example of parallel programming, or a very
   simplified example of how a "remote procedure call" might work.
*/
import java.util.Scanner;
import java.io.*;

public class UseAdder
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // get two command line arguments
      int x1 = 0, x2 = 0;
      if (args.length >= 2)
         try
         {
            x1 = Integer.parseInt(args[0]);
            x2 = Integer.parseInt(args[1]);
         }
         catch (NumberFormatException e)
         {
            System.err.println("Usage: UseAdder <number> <number>");
            System.exit(1);
         }
      else
      {
         System.err.println("Usage: UseAdder <number> <number>");
         System.exit(1);
      }

      // Create a ProcessBuilder object for running Adder.class
      ProcessBuilder pb = new ProcessBuilder("java", "Adder");

      // Pass arguments to Adder by using environment variables.
      pb.environment().put( "CS404Adder-op1", new Integer(x1).toString() );
      pb.environment().put( "CS404Adder-op2", new Integer(x2).toString() );

      // "call" Adder
      Process p = pb.start();
      // wait for the "call" to return
      p.waitFor();

      // Read the result from the Adder process's standard output.
      // Create a new stream to read data from the output of the Adder process.
      Scanner scanner = new Scanner( p.getInputStream() );
      int result = scanner.nextInt();

      // write the result to stdout
      System.out.println( result );
   }
}